#include <stdio.h>
#include <stdlib.h>

#define true 1
#define false 0

/* 								PROTOTIPOS											*/
int compInt(void *a, void *b);
void swapInt(void *a, void *b);

void bubbleSort_1(void *address, int len, int (*comp)(void *a, void *b),
		void (*swap)(void *a, void *b));

/* 									MAIN											*/
int main() {
	int array[] = { 3, 5, 8, 9, 1, 2, 4, 7, 6, 0 };
	int len = 10;

	void *address;
	address = array;

	for (int i = 0; i < len; ++i) {
		printf("%d ", array[i]);
	}
	printf("\n");

	bubbleSort_1(address, len, &compInt, &swapInt);

	for (int i = 0; i < len; ++i) {
		printf("%d ", array[i]);
	}
	printf("\n");

	return (EXIT_SUCCESS);
}

/* 							IMPLEMENTAÇÕES DE FUNÇÕES								*/

// Função utilitária para comparar int
int compInt(void *a, void *b) {
	if (*(int*) (a) > *(int*) (b)) {
		return false;
	}
	return true;
}

// Função utilitária para troca de posições
void swapInt(void *a, void *b) {
	int aux;

	aux = *(int*) (a);
	*(int*) (a) = *(int*) (b);
	*(int*) (b) = aux;
}

// Implementaçao do Bubble Sort
void bubbleSort_1(void *address, int len, int (*comp)(void *a, void *b),
		void (*swap)(void *a, void *b)) {
	int newlen;
	while (len != 0) {
		newlen = 0;
		for (int i = 1; i < len; i++) {
			if (!comp(address + i - 1, address + i)) {
				swap(address + i - 1, address + i);
				newlen = i;
			}
		}
		len = newlen;
	}
}

