#ifndef __device_h
#define __device_h

#include <config.h> // verificar uso
#include <system/mediators/uart/types.h>

__BEGIN_SYS
__BEGIN_INT

class Device 
{
public:
    Device();
    Device(const Id & devid);
    ~Device();

    const Id & devid();
    bool valid();

        int Stat(void* status);
        int In(void porta, void* palavra, void timeout, void mask, void sigvals);
        int Out(void porta, void palavra, void timeout, void mask, void sigvals);

};

class Serial
{
public:
    Serial();
    Serial(const Id & devid);
    ~Serial();

    const Id & devid();
    bool valid();

        int Stat(int* status);
        int In( INT iSerPort, PBYTE palavra, UINT uTimeOut,
                  BYTE bSigMask, BYTE bSigVals);
        int Out( INT iSerPort, BYTE palavra, UINT uTimeOut,
                   BYTE bSigMask, BYTE bSigVals);
        int Configure(INT  iSerPort, LONG lBaudRate, BYTE bParams);
        int In( INT iSerPort, int* digito, UINT uTimeOut,
                  BYTE bSigMask, BYTE bSigVals);
        int Out( INT iSerPort, int digito, UINT uTimeOut,
                   BYTE bSigMask, BYTE bSigVals);

};

__END_INT
__END_SYS

#ifdef __serial_h
#include __serial_h
#endif

#ifdef __FRAMEWORK_H
#include  __FRAMEWORK_H
#endif

#endif

