#ifndef __serial_h
#define __serial_h

#include <device.h>
#include "common.h"
#include </system/mediators/uart/8250.h>
#include </system/mediators/uart/types.h>


__BEGIN_SYS
__BEGIN_IMP

class Serial: private Device_Common
{
public:
    Serial();
    ~Serial();

    // methods
        int Stat(int* status);
        int In( INT iSerPort, PBYTE palavra, UINT uTimeOut,
                  BYTE bSigMask, BYTE bSigVals);
        int Out( INT iSerPort, BYTE palavra, UINT uTimeOut,
                   BYTE bSigMask, BYTE bSigVals);
        int Configure(INT  iSerPort, LONG lBaudRate, BYTE bParams);
        int In( INT iSerPort, int* digito, UINT uTimeOut,
                  BYTE bSigMask, BYTE bSigVals);
        int Out( INT iSerPort, int digito, UINT uTimeOut,
                   BYTE bSigMask, BYTE bSigVals);

protected:
    Uart umaUart;
    // data
};

__END_IMP
__END_SYS

#endif


