/**********************************************************************/
/*                   T Y P E S . H                                    */
/**------------------------------------------------------------------**/
/*  Task         : Define frequently used constants and macros        */
/**------------------------------------------------------------------**/
/*  Author       : Michael Tischer / Bruno Jennrich                   */
/*  Developed on : 3/20/94                                            */
/*  Last update  : 3/25/94                                            */
/**********************************************************************/
#ifndef _INC_TYPES_H
#define _INC_TYPES_H

#ifndef _FP
#define _FP far
#endif

#ifndef _NP
#define _NP near
#endif

typedef unsigned char BYTE;
typedef BYTE _FP   *LPBYTE;
typedef BYTE _NP   *NPBYTE;
typedef BYTE        *PBYTE;

typedef unsigned int  UINT;
typedef UINT _FP   *LPUINT;
typedef UINT _NP   *NPUINT;
typedef UINT        *PUINT;

typedef unsigned int  WORD;
typedef WORD _FP   *LPWORD;
typedef WORD _NP   *NPWORD;
typedef WORD        *PWORD;

typedef unsigned long ULONG;
typedef ULONG _FP  *LPULONG;
typedef ULONG _NP  *NPULONG;
typedef ULONG       *PULONG;

typedef long          LONG;
typedef LONG _FP   *LPLONG;
typedef LONG _NP   *NPLONG;
typedef LONG        *PLONG;

typedef int            INT;
typedef int  _FP    *LPINT;
typedef int  _NP    *NPINT;
typedef int          *PINT;


typedef char          CHAR;
typedef char _FP   *LPCHAR;
typedef char _NP   *NPCHAR;
typedef char        *PCHAR;

typedef void          VOID;
typedef void _FP   *LPVOID;
typedef void _NP   *NPVOID;
typedef void        *PVOID;

#define LOBYTE( w ) ( ( BYTE ) ( ( w ) & 0xFF ) )
#define HIBYTE( w ) ( ( BYTE ) ( ( ( w ) >> 8 ) & 0xFF ) )
#define MAKEWORD( h, l ) ( ( ( WORD )( h ) << 8 ) | ( WORD )( l ) )

#define LOWORD( l ) ( ( WORD )( ( l ) & 0x0000FFFF ) )
#define HIWORD( l ) ( ( WORD )( ( l ) >> 16 ) )
#define MAKELONG( h, l ) ( ( ( LONG )( h ) << 16 ) | ( LONG )( l ) )

#define TRUE  (0 == 0)
#define FALSE (0 == 1)

#define ON TRUE
#define OFF FALSE

#define NO_ERROR 0
#define ERROR 0xFFFF                       /* unspecified error */

#ifndef MK_FP
#define MK_FP(s, o)((LPVOID)((ULONG)(s)<<16|(o)))
#endif

#ifndef _interrupt
#define _interrupt interrupt
#endif

#ifndef _REGS
#define _REGS REGS
#endif

#ifndef _REGS
#define _SREGS SREGS
#endif

#ifndef _SREGS
#define _SREGS SREGS
#endif

#ifndef _int86
#define _int86 int86
#endif

#ifndef _int86x
#define _int86x int86x
#endif

#ifndef _getch
#define _getch getch
#endif

#endif


