#ifndef __atomic_h
#define __atomic_h

#include <config.h>

__BEGIN_SYS
__BEGIN_INT

class Atomic
{
public:
    Atomic();
    ~Atomic();

    const Id & id();
    bool valid();

    void lock();
    void unlock();
    static void static_lock();
    static void static_unlock();
};

class Uninterrupted
{
public:
    Uninterrupted();
    ~Uninterrupted();

    void lock();
    void unlock();
    static void static_lock();
    static void static_unlock();
};

class System_Locked
{
public:
    System_Locked();
    ~System_Locked();

    void lock();
    void unlock();
    static void static_lock();
    static void static_unlock();
};

class Class_Locked
{
public:
    Class_Locked();
    ~Class_Locked();

    void lock();
    void unlock();
    static void static_lock();
    static void static_unlock();
};

class Object_Locked
{
public:
    Object_Locked();
    ~Object_Locked();

    void lock();
    void unlock();
    static void static_lock();
    static void static_unlock();
};

__END_INT
__END_SYS

#ifdef __UNINTERRUPTED_H
#include __UNINTERRUPTED_H
#endif

#ifdef __SYSTEM_LOCKED_H
#include __SYSTEM_LOCKED_H
#endif

#ifdef __CLASS_LOCKED_H
#include __CLASS_LOCKED_H
#endif

#ifdef __OBJECT_LOCKED_H
#include __OBJECT_LOCKED_H
#endif

#endif

