#ifndef __communicator_h
#define __communicator_h

#include <config.h>

__BEGIN_SYS
__BEGIN_INT

class Communicator
{
public:
    Communicator();
    Communicator(const Id & id);
    Communicator(const Communicator & comm);
    ~Communicator();

    const Id & id();
    bool valid();

    int send(const Id & to, const void * buffer, unsigned int length);
    int receive(Id * from, const void * buffer, unsigned int * length);
};

class Link
{
public:
    Link();
    Link(const Id & id);
    Link(const Link & link);
    ~Link();

    const Id & id();
    bool valid();

    // methods
};

class Port
{
public:
    Port();
    Port(const Id & id);
    Port(const Port & port);
    ~Port();

    const Id & id();
    bool valid();

    int send(const Id & to, const void * buffer, unsigned int length);
    int receive(Id * from, const void * buffer, unsigned int * length);
};

class Mailbox
{
public:
    Mailbox();
    Mailbox(const Id & id);
    Mailbox(const Mailbox & mailbox);
    ~Mailbox();

    const Id & id();
    bool valid();

    int send(const Id & to, const void * buffer, unsigned int length);
    int receive(Id * from, const void * buffer, unsigned int * length);
};

class ARM_Segment
{
public:
    ARM_Segment();
    ARM_Segment(const Id & id);
    ARM_Segment(const ARM_Segment & arm_segment);
    ~ARM_Segment();

    const Id & id();
    bool valid();

    // methods
};

class AM_Handler
{
public:
    AM_Handler();
    AM_Handler(const Id & id);
    AM_Handler(const AM_Handler & am_handler);
    ~AM_Handler();

    const Id & id();
    bool valid();

    // methods
};

__END_INT
__END_SYS

#ifdef __LINK_H
#include __LINK_H
#endif

#ifdef __PORT_H
#include __PORT_H
#endif

#ifdef __MAILBOX_H
#include __MAILBOX_H
#endif

#ifdef __ARM_SEGMENT_H
#include __ARM_SEGMENT_H
#endif

#ifdef __AM_HANDLER_H
#include __AM_HANDLER_H
#endif

#ifdef __FRAMEWORK_H
#include  __FRAMEWORK_H
#endif

#endif

