#ifndef __cpu_h
#define __cpu_h

#ifdef htonl
#undef htonl
#undef htons
#undef ntohl
#undef ntohs
#endif

#include <config.h>

__BEGIN_SYS

// A 8 bits register 
typedef unsigned char CPU_Reg8;

// A 16 bits register 
typedef unsigned short CPU_Reg16;

// A 32 bits register 
typedef unsigned long CPU_Reg32;

// A 64 bits register 
typedef unsigned long long CPU_Reg64;

// The CPU's clock in Hz 
typedef unsigned long long CPU_Clock;

__BEGIN_INT

class CPU
{
public:
    CPU();
    ~CPU();

    static const CPU_Clock & clock();
    static CPU_Reg64 time_stamp();
    
    static CPU_Reg32 htonl(CPU_Reg32 hl);
    static CPU_Reg16 htons(CPU_Reg16 hs);
    static CPU_Reg32 ntohl(CPU_Reg32 nl);
    static CPU_Reg16 ntohs(CPU_Reg16 ns);
};

class Ix86
{
public:
    Ix86();
    ~Ix86();

    static const CPU_Clock & clock();
    static CPU_Reg64 time_stamp();
    
    static CPU_Reg32 htonl(CPU_Reg32 hl);
    static CPU_Reg16 htons(CPU_Reg16 hs);
    static CPU_Reg32 ntohl(CPU_Reg32 nl);
    static CPU_Reg16 ntohs(CPU_Reg16 ns);
};

class LANai
{
public:
    LANai();
    ~LANai();

    static const CPU_Clock & clock();
    static CPU_Reg64 time_stamp();
    
    static CPU_Reg32 htonl(CPU_Reg32 hl);
    static CPU_Reg16 htons(CPU_Reg16 hs);
    static CPU_Reg32 ntohl(CPU_Reg32 nl);
    static CPU_Reg16 ntohs(CPU_Reg16 ns);
};

__END_INT
__END_SYS

#ifdef __IX86_H
#include __IX86_H
#endif

#ifdef __LANAI_H
#include __LANAI_H
#endif

#ifdef __FRAMEWORK_H
#include  __FRAMEWORK_H
#endif

#endif

