/*======================================================================*/
/* CGA VIDEO ADAPTER (CRT Controller Motorola 6845) 	                */
/*                                                                      */
/* Auth: Guto                                                           */
/*======================================================================*/
#ifndef cga_h
#define cga_h 1

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*======================================================================*/
/* CONSTANTS                                                            */
/*======================================================================*/
/* Ix86 PORTS FOR 6845 REGISTERS */
#define	CGA_ADDR_REG		0x03d4	/* address register */
#define	CGA_DATA_REG		0x03d5	/* data register */
#define	CGA_CTRL_REG		0x03d8	/* control register */
#define	CGA_COLOR_REG		0x03d9	/* color selector register */

/* 6845 INTERNAL ADDRESSES */
#define	CGA_ADDR_CUR_START	0x0a	/* describes the cursor */
#define	CGA_ADDR_CUR_END	0x0b
#define	CGA_ADDR_PAGE_HI	0x0c	/* current frame buffer page */
#define	CGA_ADDR_PAGE_LO	0x0d
#define	CGA_ADDR_CUR_POS_HI	0x0e	/* current curor position */
#define	CGA_ADDR_CUR_POS_LO	0x0f

/* CGA text frame buffer address */
#define CGA_FBUF		0xb8000

/* CGA text frame buffer resolution */
#define CGA_LINES		25
#define CGA_COLUMNS		80
#define CGA_TAB_SIZE		8

/*======================================================================*/
/* PROTOTYPES                                                           */
/*======================================================================*/
void cga_set_fbuf(unsigned long fbuf);
void cga_clear();
void cga_gotoxy(int x, int y);
void cga_putc(char c);
void cga_puts(const char *s);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* cga_h */
