/*======================================================================*/
/* PC'S KEYBOARD CONTROLLER (Intel 8042) INTERFACE                      */
/*                                                                      */
/* Auth: Guto							     	*/
/*======================================================================*/
#ifndef keyb_h
#define keyb_h 1

/*======================================================================*/
/* CONSTANTS                                                            */
/*======================================================================*/
/* Ix86 PORTS FOR 8042 REGISTERS */
#define KEYB_DATA		0x60
#define KEYB_STATUS		0x64

/* 8042 STATUS FLAGS */
#define KEYB_STAT_OUT_BUF_FULL	0x01 /* The byte in the output buffer hasn't */
                                     /* been received by the 8042 yet */
#define KEYB_STAT_IN_BUF_FULL	0x02 /* A byte is ready in the input buffer */
#define KEYB_STAT_IGNORE	0x04 /* Ignored bit */
#define KEYB_STAT_CMD_PORT	0x08 /* 0 => PORT = 0x64, 1 => PORT = 0x60 */
#define KEYB_STAT_ACTIVE	0x10 /* Keyboard is active */
#define KEYB_STAT_OUT_TIME_OUT	0x20 /* Error: time out when outputing */
#define KEYB_STAT_IN_TIME_OUT	0x40 /* Error: time out when inputing */
#define KEYB_STAT_PARITY	0x80 /* Error: parity don't match */

/* 8042 COMMANDS */
#define KEYB_CMD_SET_LEDS	0xed
#define KEYB_CMD_SET_RATE	0xf3

/* ACK */
#define KEYB_ACK		0xfa

/*===========================================================================*/
/* KEYBOARD LED'S                                                            */
/*===========================================================================*/
#define KEYB_LED_SCROLL		(0x1)
#define KEYB_LED_NUM		(0x2)
#define KEYB_LED_CAPS		(0x4)

/*===========================================================================*/
/* PROTOTYPES                                                                */
/*===========================================================================*/
int  keyb_send(unsigned char data);
int  keyb_get_scan();
int  keyb_get_status();
int  keyb_set_leds(unsigned char leds_mask);
int  keyb_set_rate(int delay, int rate);
void keyb_flush();

#endif /* keyb_h */
