/*======================================================================*/
/* PCI BUS CONTROLLER INTERFACE						*/
/*                                                                      */
/* Auth: Guto                                                           */
/*======================================================================*/
#ifndef pci_h
#define pci_h 1

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*======================================================================*/
/* DEPENDENCIES								*/
/*======================================================================*/
/* #include <pc/ix86.h> */

/*======================================================================*/
/* CONSTANTS								*/
/*======================================================================*/
/* Offset in the ix86 address space where the PCI address space is mapped */
/* #define PCI_MEM_PHY_ADDR		0xcf800000 */
#define PCI_MEM_PHY_ADDR		0xef800000 

/* PCI address space size in bytes */
#define PCI_MEM_SIZE			0x00200000 /* 2 Mb */

/* KNOWN PCI DEVICES */
#define PCI_DEV_ID_MYRINET		0x8043

/* DEVICE MEMORY OFFSET IN THE PCI ADDRESS SPACE */
#define PCI_DEV_MEM_OFF_MYRINET		0x00000000

/* DEVICE MEMORY SIZE IN THE PCI ADDRESS SPACE */
#define PCI_DEV_MEM_SIZE_MYRINET	0x00200000

/*======================================================================*/
/* PROTOTYPES								*/
/*======================================================================*/
int pci_init(void **mem_addr, unsigned int *mem_size);
int pci_get_dev_mem_offs(unsigned short dev_id, int unit);
unsigned long pci_get_dev_mem_addr(unsigned short dev_id, int unit);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* pci_h */
