/*======================================================================*/
/* INTERRUPT CONTROLLER (INTEL 8259A) INTERFACE				*/
/*                                                                      */
/* Auth: Guto                                                           */
/*======================================================================*/
#ifndef pic_h
#define pic_h 1

/*======================================================================*/
/* CONSTANTS								*/
/*======================================================================*/
/* Ix86 PORTS FOR 8259A REGISTERS */
#define PIC_MST_CMD		0x20
#define PIC_MST_IMR		0x21
#define PIC_SLV_CMD		0xa0
#define PIC_SLV_IMR		0xa1

/* 8259A COMMANDS */
#define PIC_SEL_IRR		0x0a	/* select IRR */
#define PIC_SEL_ISR		0x0b	/* select ISR */
#define PIC_ICW1		0x11	/* flank, cascaded, more ICWs */
#define PIC_ICW4		0x01	/* manual EOI, uses ix86 */
#define PIC_EOI			0x20	/* end of interrupt */

/* Interrupt Request Lines (IRQ) */
#define IRQ0		0x0001
#define IRQ1		0x0002
#define IRQ2		0x0004
#define IRQ3		0x0008
#define IRQ4		0x0010
#define IRQ5		0x0020
#define IRQ6		0x0040
#define IRQ7		0x0080
#define IRQ8		0x0100
#define IRQ9		0x0200
#define IRQ10		0x0400
#define IRQ11		0x0800
#define IRQ12		0x1000
#define IRQ13		0x2000
#define IRQ14		0x4000
#define IRQ15		0x8000
#define IRQ_ALL		0xffff

/*===========================================================================*/
/* PROTOTYPES                                                                */
/*===========================================================================*/
void pic_enable(unsigned short mask);
void pic_disable(unsigned short mask);
void pic_set_base(unsigned char base);
void pic_eoi();
unsigned short pic_get_ISR();
unsigned short pic_get_IRR();
unsigned short pic_get_IMR();

#endif /* pic_h */
