/*======================================================================*/
/* PC'S TIMER (Intel 8253) INTERFACE                                    */
/*                                                                      */
/* Auth: Guto							     	*/
/*======================================================================*/
#ifndef timer_h
#define timer_h 1

/*======================================================================*/
/* CONSTANTS                                                            */
/*======================================================================*/
/* PORTS */
#define TIMER_CMD		0x43
#define TIMER_CH1		0x40

/* COMMANDS */
#define TIMER_SET_LEDS		0xed
#define TIMER_SET_RATE		0xf3
#define TIMER_ENABLE_A20_ADDR	0xd1
#define TIMER_ENABLE_A20_CMD	0xdf

/* STATUS */
#define TIMER_OK			0xfa

/*===========================================================================*/
/* TIMEROARD LED'S                                                            */
/*===========================================================================*/
#define TIMER_LED_SCROLL		(0x1)
#define TIMER_LED_NUM		(0x2)
#define TIMER_LED_CAPS		(0x4)

/*===========================================================================*/
/* PROTOTYPES                                                                */
/*===========================================================================*/
int  timer_send(unsigned char data);
int  timer_get_scan();
int  timer_get_status();
int  timer_set_leds(unsigned char leds_mask);
int  timer_set_rate(int delay, int rate);
void timer_flush();

void pc_enable_a20();

#endif /* timer_h */
