#ifndef __parallel_software_bus_h
#define __parallel_software_bus_h

#include <bus.h>
#include "common.h"
#include <system/abstractions/device/parallel_device/parallel_device.h>

__BEGIN_SYS
__BEGIN_IMP

//
// Parallel Software Bus as defined in IEEE1284.3
//

class Parallel_Software_Bus: private Bus_Common
{
public:
    Parallel_Software_Bus();
    ~Parallel_Software_Bus();

    // methods
    int rescan();
    bool has_multiplexer();
    void select_device(short mux_column, short dc_row);

    static int init(System_Info * si);
 
protected:
    int scan();

private:
    Parallel_Device * devices;
    int 	 device_count;
};

//
// Devices are addressed by a pair (column, row) with the column
// meaning the port of multiplexor [1..4] and with the row meaning
// the daisy-chain position [1..5]. If no multiport devices are
// instaled, (1,1) is the only selection option.
// 

__END_IMP
__END_SYS

#endif

