#ifndef __crossoverparalleldevice_h
#define __crossoverparalleldevice_h

#include "parallel_device.h"
#include <device.h>
#include <system/mediators/parport/ieee1284_parport_pc.h>

#define RECEIVE_BUFFER_SIZE  128

#ifndef NULL
#define NULL	0x0
#endif

#define Reg8 unsigned char

__BEGIN_SYS
__BEGIN_IMP


class CrossOverParallelDevice: private Parallel_Device
{
public:
    CrossOverParallelDevice();
    ~CrossOverParallelDevice();

    // methods
    static int init(System_Info *si);

    bool acquire_token();
    void release_token();

    bool send_byte(Reg8 byte);
    bool receive_byte(Reg8 & byte);

    bool send(Reg8 * data, int size);
    bool receive(Reg8 * data, int & size);

protected:
    // data
    bool      has_token;
    IEEE1284_Parport_PC * pp;
};

__END_IMP
__END_SYS

#endif

