#ifndef __envelope_common_h
#define __envelope_common_h

#include <system/config.h>
#include <string.h>

__BEGIN_SYS
__BEGIN_IMP

class Envelope_Common
{
protected:
    virtual void pack(const void * p, unsigned int l) = 0;

public:
    Envelope_Common(const Id & r, unsigned int l)
	: _recipient(r), _length(0) {}
    virtual ~Envelope_Common() {}
    
    unsigned int length() { return _length; }
    virtual void * buffer() = 0;

    Envelope_Common & operator << (class Envelope_Common & e)
	{ pack(e.buffer(), e.length()); return *this; }
    Envelope_Common & operator << (char c)
	{ pack(&c, sizeof(char)); return *this; }
    Envelope_Common & operator << (unsigned char c) 
	{ return (*this) << (char)c; }
    Envelope_Common & operator << (signed char c)
	{ return (*this) << (char)c; }
    Envelope_Common & operator << (const char * s)
	{ pack(s, strlen(s)); return *this; }
    Envelope_Common & operator << (const unsigned char * s)
	{ return (*this) << (const char*)s; }
    Envelope_Common & operator << (const signed char * s) 
	{ return (*this) << (const char*)s; }
    Envelope_Common & operator << (const void * p)
	{ pack(&p, sizeof(void *)); return *this; }
    Envelope_Common & operator << (int n)
	{ pack(&n, sizeof(int)); return *this; }
    Envelope_Common & operator << (unsigned int n) 
	{ return (*this) << (int)n; }
    Envelope_Common & operator << (long int n)
	{ pack(&n, sizeof(long int)); return *this; }
    Envelope_Common & operator << (unsigned long int n)
	{ return (*this) << (long int)n; }
    Envelope_Common & operator << (short int n)
	{ pack(&n, sizeof(short int)); return *this; }
    Envelope_Common & operator << (unsigned short int n)
	{ return (*this) << (short int)n; }
    Envelope_Common & operator << (bool b)
	{ pack(&b, sizeof(bool)); return *this; }
    Envelope_Common & operator << (double n)
	{ pack(&n, sizeof(double)); return *this; }
    Envelope_Common & operator << (float n)
	{ pack(&n, sizeof(float)); return *this; }

protected:
    Id _recipient;
    unsigned int _length;
};

__END_IMP
__END_SYS

#endif

