#ifndef __ethernet_h
#define __ethernet_h

#include <network.h>
#include "common.h"
#include <sys/socket.h>
#include <sys/socket.h>
#include <net/ethernet.h>
#include <linux/if.h>
#include <linux/if_arp.h>
#include <linux/sockios.h>

__BEGIN_SYS
__BEGIN_IMP

class Ethernet: private Network_Common
{
    typedef Traits<Ethernet> traits;

    static const Type_Id _type = traits::type;
    static const unsigned int _alen = 6;
    static const unsigned int _mtu = 1514;
    static const unsigned int _peers = traits::max_peers;
    static const unsigned int _protocol = traits::protocol;

    typedef unsigned char Address[_alen];
	
    struct Header {
	Address to;
	Address from;
	unsigned short protocol;
    };

    struct Frame {
	Header header;
	unsigned char payload[_mtu - sizeof(Header)];
    };

public:
    Ethernet();
    ~Ethernet();

    int send(const Node_Id & r, const void * b, unsigned int l);
    int receive(Node_Id * s, void * b, unsigned int * l); 

    static unsigned int mtu() { return _mtu; }

    static int init(System_Info * si);

    friend Debugger & operator << (Debugger & db, const Address & a)
	{ db << (void *)(int)a[5]; return db; }

protected:
    int _sock;
    Address _addr;
    static Address _bcast;
    static Address _arpt[_peers];
};

__END_IMP
__END_SYS

#endif

