#ifndef __condition_h
#define __condition_h

#include <synchronizer.h>
#include "common.h"
#include <pthread.h>

__BEGIN_SYS
__BEGIN_IMP

class Condition: private Synchronizer_Common
{
    typedef Traits<Condition> traits;

    static const Type_Id type = traits::type;

public:
    Condition();
    ~Condition();

    void lock();
    void unlock();
    void signal();
    void broadcast();
    void wait();

    static int init(System_Info * si);

protected:
    pthread_cond_t cond;
    pthread_mutex_t mutex;
};

__END_IMP
__END_SYS

#endif

