#ifndef __cooperative_thread_h
#define __cooperative_thread_h

#include "exclusive.h"

__BEGIN_SYS
__BEGIN_IMP

class Cooperative_Thread: public Exclusive_Thread
{
public:
    Cooperative_Thread(int (* const e)(int), int a = 0,
		       const Thread_State & s = READY);
    Cooperative_Thread(const Thread_Self & s): Exclusive_Thread(s) {}

    void stat(Thread_Status * status);
    void suspend();
    void resume();
    int join(int * exit_status);
    int pass();

    static int init(System_Info *si);

private:
  static void * initializer(void * ptr) {
    const Cooperative_Thread * thread = (const Cooperative_Thread *) ptr;
    while(thread->state != READY);
    return (void *)thread->entry(thread->argument);
  }

protected:
  volatile Thread_State state;
  int (* const entry)(int);
  int argument;
};

__END_IMP
__END_SYS

#endif

