#ifndef __object_locked_h
#define __object_locked_h

#include <atomic.h>
#include "common.h"
#include <system/abstractions/synchronizer/mutex.h>

__BEGIN_SYS

class Object_Locked: private Atomic_Common
{
public:
    void lock() { mutex.lock(); }
    void unlock() { mutex.unlock(); }

    static void static_lock() { static_mutex.lock(); }
    static void static_unlock() { static_mutex.unlock(); }

private:
    __IMP(Mutex) mutex;
    static __IMP(Mutex) static_mutex;
};

__END_SYS

#endif

