#ifndef __system_locked_h
#define __system_locked_h

#include <atomic.h>
#include "common.h"
#include <system/abstractions/synchronizer/mutex.h>

__BEGIN_SYS

class System_Locked: private Atomic_Common
{
protected:
    void lock() { mutex.lock(); }
    void unlock() { mutex.unlock(); }

    static void static_lock() { mutex.lock(); }
    static void static_unlock() { mutex.unlock(); }

private:
    static __IMP(Mutex) mutex;
};

__END_SYS

#endif

