#ifndef __global_id_h
#define __global_id_h

#include <system/mediators/node/common.h>
#include "local.h"

__BEGIN_SYS

class Global_Id: public Local_Id
{
protected:
    Global_Id() : _host(Node_Common::id()) {}
    
public:
    Global_Id(const Node_Id & h, const Type_Id & t, const Unit & u) :
	Local_Id(t, u), _host(h) {}
    Global_Id(const Type_Id & t, const Unit & u) :
	Local_Id(t, u), _host(Node_Common::id()){}
    
    const Node_Id & host() const { return _host; }

    friend Debugger & operator << (Debugger & db, const Global_Id & id)
	{ db << "[h=" << id.host() << ",t=" << id.type() << ",u="  
	     << id.unit() << "]" ; return db; }

private:
    Node_Id _host;
};

__END_SYS

#endif

