/*======================================================================*/
/* BOOT STRAP DEFINITIONS                                               */
/*                                                                      */
/* Auth: Guto                                                           */
/*======================================================================*/
#ifndef boot_h
#define boot_h 1

/*======================================================================*/
/* DEPENDENCIES                                                         */
/*======================================================================*/
#include <system/memory_map.h>

/*======================================================================*/
/* CONSTANTS                                                            */
/*======================================================================*/
/* FHYSICAL MEMORY MAP */
/* 0x0000 0000 -+-----------------------+ BOOT_IDT */		
/*		| IDT (4 K)		| */			
/* 0x0000 1000 -+-----------------------+ BOOT_GDT */	
/*		| GDT (4 K)		| */			
/* 0x0000 2000 -+-----------------------+ */ 	
/*		: 			: */			
/*		| BOOT STACK (23 K)	| */			
/* 0x0000 7c00 -+-----------------------+ BOOTSTRAP_STACK, BOOTSTRAP_CODE */
/*		| BOOT CODE (512 b)	| */			
/* 0x0000 7e00 -+-----------------------+ */			
/*		| RESERVED (512 b)	| */			
/* 0x0000 8000 -+-----------------------+ DISK_IMAGE */	
/*		| DISK IMAGE (608 K)	| */			
/*		: 			: */			
/*		|			| */
/* 0x000a 0000 -+-----------------------+ */			
/*		| UNUSED (384K)		| */			
/*		: 			: */			
/*		|			| */		
/* 0x000f f000 -+-----------------------+ */
#define BOOT_IDT		0x0000
#define BOOT_GDT		0x1000
#define BOOTSTRAP_STACK		0x7c00	/* Descendent */
#define BOOTSTRAP_CODE		0x7c00	/* The bootstrap code (512 bytes) */
#define DISK_IMAGE		BOOT_IMAGE_PHY_ADDR

/* The size of a disk sector in bytes */
#define DISK_SECT_SIZE		512	

/* The size of ELF object's header in bytes */
#define ELF_HDR_SIZE	 	128

/* DISK IMAGE LAYOUT */
/* -+-----------------------+ DISK_IMAGE_SYS_INFO */	
/*  | SYS_INFO (512 bytes)  | */			
/* -+-----------------------+ DISK_IMAGE_SETUP */	
/*  | SETUP		    | */		
/*  :			    : */
/* -+-----------------------+ */			
/*  | SYSTEM		    | */		
/*  :			    : */
/* -+-----------------------+ */			
/*  | INIT		    | */		
/*  :			    : */
/* -+-----------------------+ */			
/*  | LOADER/APP1	    | */		
/*  :			    : */
/* -+-----------------------+ */			
/*  | APP1		    | */		
/*  :			    : */
/* -+-----------------------+ */			
/*  :			    : */
/* -+-----------------------+ */			
/*  | APPn		    | */		
/*  :			    : */
/* -+-----------------------+ */			
/* BOOT IMAGE LAYOUT */
/* System Information */
#define DISK_IMAGE_SYS_INFO	DISK_IMAGE

/* System Information */
#define DISK_IMAGE_SETUP	(DISK_IMAGE + DISK_SECT_SIZE)

/* SETUP entry point */
#define SETUP_ENTRY		(DISK_IMAGE_SETUP + ELF_HDR_SIZE)

#endif /* boot_h */
