#ifndef __system_config_h
#define __system_config_h

#ifndef __DEF
#define __DEF
#endif

//============================================================================
// MACROS
//============================================================================
#define __SYS_NS		System
#define __BEGIN_SYS		namespace __SYS_NS {
#define __END_SYS		}
#define __USING_SYS		using namespace __SYS_NS;
#define __REG(M)		__BEGIN_SYS class M; __END_SYS

#define __INT_NS		Int
#define __BEGIN_INT		namespace __INT_NS {
#define __END_INT		}
#define __USING_INT		using namespace __INT_NS;
#define __INT(X)		Int::X
#define __REG_INT(M)		__BEGIN_SYS __BEGIN_INT class M;\
	 			__END_INT __END_SYS
#define __EXP_INT(M)		__BEGIN_SYS typedef __INT(M) M; __END_SYS

#define __IMP_NS		Imp
#define __BEGIN_IMP		namespace __IMP_NS {
#define __END_IMP		}
#define __USING_IMP		using namespace __IMP_NS;
#define __IMP(X)		Imp::X
#define __REG_IMP(M)		__BEGIN_SYS __BEGIN_IMP class M;\
	 			__END_IMP __END_SYS
#define __EXP_IMP(M)		__BEGIN_SYS typedef Handle<__IMP(M)> M; \
				__END_SYS

#ifdef	ANALYZE
#define __EXPORT_ABS(F,M)	__REG_INT(M##_##F); __EXP_INT(M##_##F)
#define __EXPORTN_ABS(F,M)	__REG_INT(M); __EXP_INT(M)
#else
#define __EXPORT_ABS(F,M)	__REG_IMP(M##_##F); __EXP_IMP(M##_##F)
#define __EXPORTN_ABS(F,M)	__REG_IMP(M); __EXP_IMP(M)
#endif

#ifdef	ANALYZE
#define __EXPORT_MED(F,M)	__REG_INT(M##_##F)
#define __EXPORTN_MED(F,M)	__REG_INT(M)
#else
#define __EXPORT_MED(F,M)	__REG(M##_##F)
#define __EXPORTN_MED(F,M)	__REG(M)
#endif

#ifdef	ANALYZE
#define __EXPORT_ASP(F,M)	__REG_INT(M##_##F); __EXP_INT(M##_##F)
#define __EXPORTN_ASP(F,M)	__REG_INT(M); __EXP_INT(M)
#else
#define __EXPORT_ASP(F,M)	__REG(M##_##F) 
#define __EXPORTN_ASP(F,M)	__REG(M)
#endif

#define __BIND(F,M) 		__BEGIN_SYS typedef M##_##F F; __BEGIN_IMP \
				typedef M##_##F F; __END_IMP __END_SYS
#define __BINDN(F,M)		__BEGIN_SYS typedef M F; __BEGIN_IMP \
				typedef M F; __END_IMP __END_SYS
#define __UNBIND(F) 		__REG_INT(F); __EXP_INT(F)

#define __BIND_MED(F,M)		__BEGIN_SYS typedef M##_##F F; __END_SYS
#define __BINDN_MED(F,M)	__BEGIN_SYS typedef M F; __END_SYS

#ifdef SYSTEM
#define __HEADER_ABS(H)		<system/config.h>
#define __HEADER_FMK(H)		<system/config.h>
#else
#define __HEADER_ABS(H)		<system/abstractions/H.h>
#define __HEADER_FMK(H)		<H.h>
#endif
#define __HEADER_MED(H)		<system/mediators/H.h>
#define __HEADER_ASP(H)		<system/aspects/H.h>

//============================================================================
// SYSTEM NAMESPACE ORGANIZATION
//============================================================================
__BEGIN_SYS
template <class Imp> class Handle;
template <class Imp> class Adapter;
template <class Imp> class Scenario;
template <class Imp> class Config;
__BEGIN_INT __END_INT
__BEGIN_IMP __END_IMP
__END_SYS


#define CONF_ETHERNET_LINUX_DEV	"wvlan0"
#define CONF_ETHERNET_ARP_TABLE { \
    {0x00, 0x60, 0x1D, 0x23, 0xD3, 0xC8}, \
    {0x00, 0x60, 0x1D, 0x23, 0xD3, 0x8A} }



#endif


