/*======================================================================*/
/* DEBUG.H                                                      	*/
/*                                                                      */
/* Desc: Debug functions interface.		                      	*/
/*======================================================================*/
#ifndef debug_h
#define debug_h 1

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*======================================================================*/
/* DEPENDENCIES								*/
/*======================================================================*/
#include <system/kprintf.h>

/*======================================================================*/
/* TYPES								*/
/*======================================================================*/
typedef enum
{
  DB_ABORT,
  DB_ERROR,
  DB_WARNING,
  DB_INFO,
  DB_TRACE
} Debug_Level;
 
typedef enum
{
  DB_SETUP,
  DB_INIT,
  DB_SYSTEM,
  DB_GUEST,
  DB_QUEUE,
  DB_SYSCALL,
  DB_TIMER,
  DB_CHRONOMETER,
  DB_NETWORK,
  DB_THREAD,
  DB_SEMAPHORE
} Debug_Module;

/*======================================================================*/
/* PROTOTYPES								*/
/*======================================================================*/
void debug(Debug_Level level, Debug_Module module, const char *format, ...);
void debugn(Debug_Level level, Debug_Module module, const char *format, ...);
const char *debug_dump(const char *format, ...);

/*======================================================================*/
/* MACROS								*/
/*======================================================================*/
#ifdef DBLEV
extern char *debug_levels[];
extern char *debug_modules[];
extern char debug_buffer[];

#ifndef DBMOD
#define DBMOD 0xFFFFFFFF
#endif /* DBMOD */

#define debug(level, module, format, args...) \
  if(((1 << level) & (DBLEV)) && ((1 << module) & (DBMOD)))\
  {\
    kprintf("%s:%s> ", debug_levels[level], debug_modules[module]);\
    kprintf(format, ## args);\
  }

#define debugn(level, module, format, args...) \
  if(((1 << level) & (DBLEV)) && ((1 << module) & (DBMOD)))\
    kprintf(format, ## args);

#define debug_dump(format, args...) \
({ksprintf(debug_buffer, format, ## args); (debug_buffer);})

#else /* DBLEV */

#define debug(level, module, format, args...)
#define debugn(level, module, format, args...)
#define debug_dump(format, args...)	0

#endif /* DBLEV */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* debug_h */

