#ifndef __scenario_h
#define __scenario_h

#include <debugged.h>
#include <id.h>
#include <shared.h>
#include <allocated.h>
#include <protected.h>
#include <timed.h>
#include <atomic.h>

__BEGIN_SYS

template<class Imp>
class Scenario: public Id
#ifdef __ATOMIC
, private __ATOMIC
#endif
#ifdef __SHARED
, private __SHARED
#endif
#ifdef __PROTECTED
, private __PROTECTED
#endif
#ifdef __ALLOCATED
, private __ALLOCATED
#endif
#ifdef __TIMED
, private __TIMED
#endif
{
protected:
  static Adapter<Imp>* alloc()
    { return (Adapter<Imp>*)::operator new(sizeof(Adapter<Imp>)); }

  static Adapter<Imp>* get(const Id & id)
    { return alloc(); }

  static Adapter<Imp>* share(const Id & id)
    { return alloc(); }

  static Adapter<Imp>* share(Adapter<Imp>* adapter)
    { return adapter; }

  static void free(Adapter<Imp>* obj)
    { delete obj; }

  void enter() {
#ifdef __ATOMIC
    lock();
#endif
  }

  void leave() {
#ifdef __ATOMIC
    unlock();
#endif
  }

  static void static_enter() {
#ifdef __ATOMIC
    static_lock();
#endif
  }

  static void static_leave() {
#ifdef __ATOMIC
    static_unlock();
#endif
  }
};

__END_SYS

#endif
