/*======================================================================*/
/* SYSTEM INFORMATION   		                                */
/*                                                                      */
/* Auth: Guto								*/
/*======================================================================*/
#ifndef system_info_h
#define system_info_h 1

/*======================================================================*/
/* TYPES	                                                        */
/*======================================================================*/
/* A map to describe the physical memory organization */
typedef struct
{
  unsigned long idt;         /* IDT, 1 page */
  unsigned long gdt;         /* GDT, 1 page */
  unsigned long sys_pt;      /* System Page Table, 1 page */
  unsigned long sys_pd;      /* System Page Directory, 1 page */
  unsigned long sys_info;    /* System Info, 1 page */
  unsigned long thread_tab;  /* Thread Table, 1 page per Thread */
  unsigned long as_tab;      /* Address Space Table, 1 page per Task */
  unsigned long phy_mem_pts; /* Page tables to map the whole physical memory*/
  unsigned long pci_mem_pts; /* Page tables to map the PCI address space */
  unsigned long sys_code;    /* OS Code Segment */
  unsigned long sys_data;    /* OS Data Segment */
  unsigned long sys_stack;   /* OS Stack Segment, 1 page */
  unsigned long app_lo;      /* Application memory begin */
  unsigned long app_hi;      /* Application memory end  */
} Physical_Memory_Map;

/* A map to describe a process logical addess space */
typedef struct
{
  unsigned long app_lo;      /* Application address space begin */
  unsigned long app_hi;      /* Application address space end  */
  unsigned long phy_mem;     /* Whole physical memory (contiguos) */
  unsigned long pci_mem;     /* PCI address space */
  unsigned long idt;         /* IDT */
  unsigned long gdt;         /* GDT */
  unsigned long sys_pt;      /* System Page Table */
  unsigned long sys_pd;      /* System Page Directory */
  unsigned long sys_info;    /* System Info */
  unsigned long thread_tab;  /* Thread Table */
  unsigned long as_tab;      /* Address Space Table */
  unsigned long sys_code;    /* OS Code Segment */
  unsigned long sys_data;    /* OS Data Segment */
  unsigned long sys_stack;   /* OS Stack Segment */
} Logical_Memory_Map;

/* The information we have at boot time */
typedef struct
{
  unsigned long mem_size;     /* Memory size in bytes */
  int cpu_type;               /* Processor type */
  int cpu_clock;              /* Processor clock frequency in Hz */
  int n_threads;              /* Max number of threads */
  int n_tasks;                /* Max number of tasks */
  unsigned short node_id;     /* The local node id (-1 => RARP) */
  unsigned short n_nodes;     /* Number of nodes in SAN */
  int img_size;               /* Boot image size in bytes */
  int setup_off;              /* SETUP offset in the boot image */
  int system_off;             /* OS offset in the boot image */
  int init_off;               /* INIT offset in the boot image */
  int loader_off;             /* LOADER offset in the boot image */
  int app_off;                /* APPs offset in the boot image */
} Boot_Info;

/* A structure to gathered the information we have about the system */
typedef struct
{
  Boot_Info boot_info;
  Physical_Memory_Map phy_mem_map;
  Logical_Memory_Map log_mem_map;
  unsigned long mem_size;      /* in pages */
  unsigned long mem_free;      /* in pages */
} System_Info;

#endif /* system_info_h */
