#ifndef __parport_common_h
#define __parport_common_h

#include <system/config.h>

__BEGIN_SYS

/* A 8 bits register */
typedef unsigned char Reg8;

/* A parallel port Mode */
typedef unsigned char Mode;

#define COMPAT	0
#define NIBBLE	1
#define BYTE	2
#define EPP	3
#define ECP	4

class Parport_Common
{
protected:
    Parport_Common() {}

public:
    bool read(Reg8 & byte);	// reads a byte from parallel port
    bool write(Reg8 byte);	// writes a byte to parallel port
    
    Mode change_mode(Mode mode); // changes parallel port mode and returns current mode
    Mode get_mode();             // returns current parallel port mode

    bool read_burst(int init_pointer, int size);  // performs a read burst on parallel port
    bool write_burst(int init_pointer, int size); // performs a write burst on parallel port

protected:
    // data
    Mode mode;
};

__END_SYS

#endif

