#ifndef __ieee1284_parport_pc_h
#define __ieee1284_parport_pc_h

#include <parport.h>
#include "common.h"
#include <pc/ix86.h>

__BEGIN_SYS

class IEEE1284_Parport_PC: private Parport_Common
{
public:
  IEEE1284_Parport_PC();
  IEEE1284_Parport_PC(Ix86_Reg16 port);
  ~IEEE1284_Parport_PC();

  // methods

  Mode change_mode(Mode mode); 
  Mode get_mode();

  void set_pin_01(bool value);

  bool get_pin_10();

  void set_pin_11(bool value);
  bool get_pin_11();

  void get_status(Reg8 & byte);
  void set_status(Reg8 byte);

  void get_control(Reg8 & byte);
  void set_control(Reg8 byte);

  bool read(Reg8 & byte);           
  bool write(Reg8 byte); 

  bool read_burst(int init_pointer, int size);  
  bool write_burst(int init_pointer, int size);

  static int init(System_Info *si);

protected:
  // data
  Ix86_Reg16 port;

};

//
// base+0          data
// base+1          status
// base+2          control
//

__END_SYS

#endif
