#ifndef __uniform_h
#define __uniform_h

//============================================================================
// ALLOCATED							
//============================================================================
#if #CONF_ALLOCATED (Ahead)
#define __ALLOCATED Ahead
#define __STATIC_ALLOCATED_H __HEADER_ASP(allocated/ahead)

#elif #CONF_ALLOCATED (Dynamic)
#define __ALLOCATED Dynamic_Allocated
#define __LATE_H __HEADER_ASP(allocated/late)
#endif

//============================================================================
// ATOMIC							
//============================================================================
#if #CONF_ATOMIC (Uninterrupted)
#define __ATOMIC Uninterrupted
#define __SYSTEM_ATOMIC_H __HEADER_ASP(atomic/uninterrupted)

#elif #CONF_ATOMIC (System)
#define __ATOMIC System_Locked
#define __SYSTEM_ATOMIC_H __HEADER_ASP(atomic/system)

#elif #CONF_ATOMIC (Class)
#define __ATOMIC Class_Locked
#define __CLASS_ATOMIC_H __HEADER_ASP(atomic/class)

#elif #CONF_ATOMIC (Object)
#define __ATOMIC Object_Locked
#define __OBJECT_ATOMIC_H __HEADER_ASP(atomic/object)

// #if ! #CONF_SYNCHRONIZER (Mutex)
// #assert CONF_SYNCHRONIZER (Mutex) 
// #endif

#endif

//============================================================================
// DEBUGGED							
//============================================================================
#if #CONF_DEBUGGED (Watched)
#define __DEBUGGED Watched
#define __WATCHED_H __HEADER_ASP(debugged/watched)

#elif #CONF_DEBUGGED (Traced)
#define __DEBUGGED Traced
#define __TRACED_H __HEADER_ASP(debugged/traced)

#elif #CONF_DEBUGGED (Profiled)
#define __DEBUGGED Profiled
#define __PROFILED_H __HEADER_ASP(debugged/profiled)
#endif

//============================================================================
// PROTECTED							
//============================================================================
#if #CONF_PROTECTED (Checked)
#define __PROTECTED Checked
#define __CHECKED_H __HEADER_ASP(protected/checked)

#elif #CONF_PROTECTED (Permitted)
#define __PROTECTED Permitted
#define __PERMITTED_H __HEADER_ASP(protected/permitted)
#endif

//============================================================================
// TIMED							
//============================================================================
#if #CONF_TIMED (Limited)
#define __TIMED Limited
#define __LIMITED_H __HEADER_ASP(timed/limited)

#elif #CONF_TIMED (Delayed)
#define __TIMED Delayed
#define __DELAYED_H __HEADER_ASP(timed/delayed)
#endif

//============================================================================
// SHARED							
//============================================================================
#if #CONF_SHARED (Referenced)
#define __SHARED Referenced
#define __REFERENCED_H __HEADER_ASP(shared/referenced)

#elif #CONF_SHARED (Enrolled)
#define __SHARED Enrolled
#define __ENROLLED_H __HEADER_ASP(shared/enrolled)
#endif



#include <system/frameworks/uniform/handle.h>

#endif
