/*======================================================================*/
/* INIT_MYRINET.C							*/
/*									*/
/* Dsc: Initialize Myrinet NIC.						*/
/* Cre: 98/03/29	Upd: 98/03/29					*/
/* Aut: Guto								*/
/*======================================================================*/
#include <ix86.h>
#include <aboelha/types.h>
#include <aboelha/mem.h>
#include <aboelha/capability.h>
#include <aboelha/interface.h>
#include "init.h"

/*======================================================================*/
/* References to Kernel structures                                      */
/*======================================================================*/
extern Segment_Descriptor Segment_Table[];

/*======================================================================*/
/* myrinet_init                                                         */
/*                                                                      */
/* Dsc: Initializes the Myrinet NIC. First creates a memory segment	*/
/*	mapped into Myrinet's SRAM.					*/
/*======================================================================*/
int init_myrinet(Word unit, Capability *cap)
{
  #define MYRINET_BASE	0xE3000000
  #define MYRINET_SIZE	0x00200000

  int i;
  Word seg_id;
  Dwrd frame;
  Dwrd *page_table;
  Segment_Descriptor *seg;
  Capability capability;

  /* Get a dummy memory segment */-I/home/snow/guto/epos/include -DDBLEV=0xff system.cc
  if(segment_create(0, 0, &seg_id) < 0)
  {
    printstr("Warning: Can not create Myrinet segment!\n");
    return(-1);
  }

  /* Map Myrinet SRAM into the just created segment */
  seg = &Segment_Table[seg_id];
  seg->size = MYRINET_SIZE;

  page_table = (Dwrd *)(seg->pt + PHYSICAL_MEMORY_BASE);
  for(i = 0, frame = MYRINET_BASE;
      i < (MYRINET_SIZE / sizeof(Page));
      i++, frame += sizeof(Page))
    page_table[i] = frame | USER_PAGE_FLAGS | IX86_PAGE_RW | IX86_PAGE_PCD;

  /* Create a capability for the Myrinet memory segment */
  if(capability_create(SEGMENT_SERVER, seg_id, cap) < 0)
  {
    printstr("Error: can not create Myrinet segment capability!");
    return(-1);
  }

  return(0);
}
