/*======================================================================*/
/* I/O BUS CONTROLLER IMPLEMENTATION					*/
/*                                                                      */
/* Auth: Guto                                                           */
/*======================================================================*/
#include <pc/pci.h>
#include <system/memory_map.h>

/*======================================================================*/
/* io_bus_init								*/
/*                                                                      */
/* Desc: Should initializes the I/O bus, but as the BIOS usually did it	*/
/*	 for us, do nothing and go for a coffee.		 	*/
/*                                                                      */
/* Parm: io_mem_addr <- address in the ix86 linear address space where	*/
/*		 	the I/O address space is mapped			*/
/*	 io_mem_size <- the I/O address space size in bytes	    	*/
/*                                                                      */
/* Rtrn: 0 on success, -1 on failure                                    */
/*======================================================================*/
int io_bus_init(void **mem_addr, unsigned int *mem_size)
{
  return pci_init(mem_addr, mem_size);
}

/*======================================================================*/
/* io_bus_get_dev_mem							*/
/*                                                                      */
/* Desc: Returns a pointer into the I/O bus address space where one	*/
/*	 can find the memory of a given I/O device.	   		*/
/*                                                                      */
/* Parm: dev_id -> the I/O device id					*/
/*	 unit   -> the I/O device unit				    	*/
/*                                                                      */
/* Rtrn: a pointer to I/O device's memory on success			*/
/*	 0 on failure                                    		*/
/*======================================================================*/
void *io_bus_get_dev_mem(unsigned short dev_id, int unit)
{
  int offset;

  switch(dev_id)
  {
    case PCI_DEV_ID_MYRINET:
      if(unit == 0)
      {
	offset = pci_get_dev_mem_offs(dev_id, unit);
	if(offset >= 0)
	  return (void *)(offset + PCI_MEM_LOG_ADDR);
      }
  }

  return 0;
}
