/*======================================================================*/
/* OS DEBUG FUNCTIONS INTERFACE						*/
/*                                                                      */
/* Auth: Guto								*/
/*======================================================================*/
#include <pc/ix86.h>
#include <system/kprintf.h>
#include <system/debug.h>
#include <system/system_object_id.h>

extern "C"
{
extern char *debug_buffer;
const char *debug_oid(const void *oid);
const char *debug_pt(const void *pt);
}

/*======================================================================*/
/* debug_oid								*/
/*                                                                      */
/* Desc: prints an object identifier into a string.		        */
/*                                                                      */
/* Parm: pt -> a pointer to the object identifier                       */
/*                                                                      */
/* Rtrn: a pointer to the string representing the object identifier     */
/*======================================================================*/
const char *debug_oid(const void *oid)
{
  System_Object_Id *id = (System_Object_Id *)oid;

  ksprintf(debug_buffer, "{h=%d, t=%d, u=%d, r=%x, c=%x}", id->get_host(),
	   id->get_type(), id->get_unit(), id->get_rights(), id->get_check());

  return debug_buffer;
}

/*======================================================================*/
/* debug_pt								*/
/*                                                                      */
/* Desc: dumps 128 entries of an ix86 page table into a string.         */
/*                                                                      */
/* Parm: pt -> a pointer to the page table                              */
/*                                                                      */
/* Rtrn: a pointer to the string representing the page table            */
/*======================================================================*/
const char *debug_pt(const void *pt)
{
  Ix86_PTE *aux;
  int i, j;

  aux = (Ix86_PTE *)pt;

  ksprintf(debug_buffer, "Page table at %p (log. addr.) =>\n\n", aux);
  for(i = 0; i < 128; i+= 8)
  {
    kprintf(debug_buffer, "\n[%x] ", i);
    for(j = 0; j < 8; j++)
      kprintf(debug_buffer,"%p ", aux[i + j]);
  }
  kprintf(debug_buffer,"\n");

  return debug_buffer;
}
