#include "lanai4_def.h"
#include </home/snow/guto/epos/system_config_keys.h>
#define __network_myrinet_h
#define __cpu_h
#include <net/myrinet/nic.h>
#include <net/myrinet/mcp.h>

int main()
{
  MCP mcp;

  return 0;
}

MCP::MCP( )
{
  // Disable the generation of interrupts to the LANai
  IMR = 0;

  // Reset LANai when an incoming packet is not consumed in time and
  // enable the generation of CRC
  MYRINET = CRC_ENABLE_BIT | NRES_ENABLE_BIT;

  // Configure Myrinet link interface by assigning LANai version to VERSION
  VERSION = LANAI_VERSION;

  // Set the timeout for LANai to consume an incoming packet
  TIMEOUT = LANAI_TIMEOUT;

  // Enable nic <-> host DMA bursts of LANAI_DMA_BURST_SIZE words
  DMA_STS = LANAI_DMA_BURST;
 
  // Empty channel
  ST = 0;

  // MCP's shared memory starts at MYRINET_CP_SHMEM_ADDR, which should be 
  // after MCP code + MCP stack
  shmem = (MCP_Shmem *)MCP_SHMEM_ADDR;
  shmem->debug = 0;

  // MCP's message buffer starts after the shared memory
  // These pointers are used for DMA and must be word aligned
//   rbuf[0] = (char *)shmem + sizeof(MCP_Shmem);
//   sbuf[0] = rbuf[0] + shmem->mtu;
  rbuf[0] = (char *)0x20000;
  sbuf[0] = (char *)0x80000;

  rbuf_ebus_addr[0] = shmem->phy_addr + MYRINET_SRAM_BASE + rbuf[0];
  sbuf_ebus_addr[0] = shmem->phy_addr + MYRINET_SRAM_BASE + sbuf[0];

  // Reset the flags used by the host to determine if a message is ready
  shmem->rmsg.status = NIC_CLEAR_TO_RECEIVE;
  shmem->smsg.status = NIC_CLEAR_TO_SEND;

  // Handshake with host if not a consume time-out reset
  if(!(ISR & NRES_INT_BIT)) {
    while(shmem->status != HOST_READY);
    shmem->status = NIC_READY;
  } else {
    shmem->statistics.resets++;
  }

  for(;;) {
    if(ISR & HALF_RDY_BIT)
      receive();
    if(shmem->smsg.status == HOST_READY_TO_SEND)
      send();
  }
}

void MCP::send() 
{
  MCP_Message *msg = &shmem->smsg;

  if(msg->header.node_id > shmem->n_nodes) {
    shmem->statistics.routing_errors++;
    msg->status = SEND_ERROR;
    return;
  }

  if(msg->header.length > shmem->mtu) {
    shmem->statistics.length_errors++;
    msg->status = SEND_ERROR;
    return;
  }

  DMA_DIR = 1;
  EAR = msg->body;
  LAR = sbuf_ebus_addr[0];
  DMA_CTR = msg->header.length;
  while(!(ISR & DMA_INT_BIT));

  for(unsigned int i = 0;
      (i < shmem->route_len) && shmem->routes[msg->header.node_id][i];
      i++) {
    while(!(ISR & SEND_RDY_BIT));
    SB = shmem->routes[msg->header.node_id][i];
  }

  while(!(ISR & SEND_RDY_BIT));
  SH = MCP_PACKET_TYPE;

  while(!(ISR & SEND_RDY_BIT));
  SW = msg->header.length;

  while(!(ISR & SEND_RDY_BIT));
  SW = shmem->node_id;

  SMP = sbuf[0];
  SMLT = sbuf[0] + msg->header.length - sizeof(int);
  while(!(ISR & SEND_INT_BIT));

  shmem->statistics.packets_sent++;
  msg->status = SEND_OK;
}

void MCP::receive() 
{
  MCP_Message *msg = &shmem->rmsg;

  unsigned short hdr = RH;
  if(hdr != MCP_PACKET_TYPE) {
    drop();
    shmem->statistics.header_errors++;
    return;
  }

  while(!(ISR & WORD_RDY_BIT));
  unsigned long len = RW;
  if(!len || (len & sizeof(int) - 1) || (len > shmem->mtu) ||
     (len > msg->header.length)) {
    drop();
    shmem->statistics.length_errors++;
    msg->status = RECEIVE_ERROR;
    return;
  }
  msg->header.length = len;

  while(!(ISR & WORD_RDY_BIT));
  msg->header.node_id = RW;

  RMP = rbuf[0];
  RML = rbuf[0] + len - sizeof(int);
  while(!(ISR & (RECV_INT_BIT | BUFF_INT_BIT)));

  while(!(ISR & BYTE_RDY_BIT));
  unsigned char crc = RB;
  LED = 0;
  if(!(ISR & TAIL_INT_BIT)) {
    drop();
    shmem->statistics.trailer_errors++;
    msg->status = RECEIVE_ERROR;
    return;
  }

  while(msg->status != HOST_READY_TO_RECEIVE);

  DMA_DIR = 0;
  EAR = msg->body;
  LAR = rbuf_ebus_addr[0];
  DMA_CTR = len;
  while(!(ISR & DMA_INT_BIT));

  if(crc) {
    shmem->statistics.crc_errors++;
    msg->status = RECEIVE_ERROR;
    return;
  }

  shmem->statistics.packets_received++;
  msg->status = RECEIVE_OK;
}

void MCP::drop()
{
  volatile char c;

  while(!(ISR & TAIL_INT_BIT)) {
    while(!(ISR & BYTE_RDY_BIT));
    c = RB;
  }

  shmem->statistics.packets_droped++;
}


// void MCP::receive() 
// {
//   short hdr;
//   char crc;
//   MCP_Statistics *stat;
//   MCP_Message *msg;

//   trace[2] = 1;

//   msg = &shmem->incoming_message;
//   stat = &shmem->statistics;

//   while(!(ISR & HALF_RDY_BIT))
//     touch(ISR);

//   trace[6] = 1;

//   hdr = RH;
//   if(hdr != PACKET_TYPE)
//   {
//     if((hdr != 0) && (hdr != 0x2c00))
//       trace[9] = hdr;
//     trace[6] = 2;
//     drop_packet();
//     stat->header_errors++;
//     return;
//   }

//   trace[7] = 3;


//   if(msg->status != MSG_FREE)
//   {
//     trace[8] = 1;
//     stat->overruns++;
//     drop_packet();
//     return;
//   }

//   trace[8] = 4;

//   while(!(ISR & WORD_RDY_BIT))
//     touch(ISR);

//   trace[8] = 5;

//   msg->length = RW;
//   if(msg->length <= 0)
//   {
//     stat->length_errors++;
//     drop_packet();
//     return;
//   }

//   trace[8] = 8;

//   while(!(ISR & WORD_RDY_BIT))
//     touch(ISR);
//   msg->address = RW;

//   trace[8] = 9;


//   RMP = (int *)buffer;
//   RML = (int *)(buffer + msg->length);

//   while(!(ISR & BUFF_INT_BIT))
//     touch(ISR);

//   trace[8] = 10;


//   while(!(ISR & BYTE_RDY_BIT))
//     touch(ISR);

//   trace[8] = 11;

//   crc = RB;
//   if(crc)
//     stat->crc_errors++;

//   if(!(ISR & TAIL_INT_BIT))
//   {
//     trace[8] = 12;
//     stat->trailer_errors++;
//     drop_packet();
//   }

//   trace[7] = 72;

//   msg->buffer = buffer;
//   msg->status = MSG_READY;

//   stat->receives++;

//   trace[7] = 92;
  
//   return;
// }

// void MCP::drop_packet()
// {
//   int drop;

//   trace[3]++;

//   while(!(ISR & TAIL_INT_BIT))
//   {
//     trace[4]++;

//     while(!(ISR & BYTE_RDY_BIT))
//       touch(ISR);
//     trace[5] = RB;
//     touch(ISR);
//   }

//   trace[3]++;

//   //clear_TAIL_INT_BIT();
// }



