#include <system/kprintf.h>
#include <myrinet.h>

USING_SYSTEM_NAMESPACE

int main()
{
  kprintf("Myrinet Test\n");

  char buffer[] = "test";
  Myrinet na;
  Myrinet na2(na);
  Myrinet na3(na.get_id());

  if(!na.is_valid())
    return -1;

  Network_Id nid = na.get_nid();
  kprintf("Host id = %d\n", nid);

  Network_Address address = na.get_address();
  kprintf("Host MAC = %Lx\n", address);

  Network_Status status;
  if(na.stat(&status) < 0)
    return -1;
  kprintf("Status = {\n");
  kprintf("  header errors = %d\n", status.header_errors);
  kprintf("}\n");


  if(na.reset() < 0)
    return -1;

  if(na.send(1, (void *)buffer, sizeof(buffer)) < 0)
    return -1;

  unsigned int len = sizeof(buffer);
  Network_Id src;
  if(na.receive(&src, (void *)buffer, &len) < 0)
    return -1;

  return 0;
}
