#include <system/kprintf.h>
#include <network_adapter.h>
#include <chronometer.h>

#define N_ITER 1000
#define MAX_MESSAGE_LEN 65536

int send_buffer[MAX_MESSAGE_LEN / sizeof(int)];
int receive_buffer[MAX_MESSAGE_LEN / sizeof(int)];

int main()
{
  Chronometer chrono;
  Timer_Tick chrono_overhead, time;
  Elapsed_Time latency;
  double bandwidth;
  Network_Adapter<> na;
  Network_Adapter_Id src;
  int fd, r_len;

  kprintf("Myrinet Ping Test\n");

  if(!na.is_valid())
  {
    kprintf("Error: can not access Myrinet!\n");
    return -1;
  }

  for(int i = 0; i < sizeof(send_buffer) / sizeof(int); i++)
    send_buffer[i] = i;

  chrono.reset();
  chrono.start();
  chrono.stop();
  chrono_overhead = chrono.read();

  kprintf("Chronometer Overhead: %u ticks (%u ns)\n",
	  (unsigned)chrono_overhead, 
	  (unsigned)Elapsed_Time(chrono_overhead) * 1E9);
 
  kprintf("Packet size(b)\tLat(ticks)\tLat(us)\t\tBandwidth(Kbytes/s)\n");
  for(int len = 4; len <= sizeof(send_buffer); len <<= 1)
  {
    kprintf("%d\t\t", len);

    na.send(7, send_buffer, len);
    r_len = sizeof(receive_buffer);
    na.receive(&src, receive_buffer, &r_len);

    chrono.reset();
    chrono.start();
    for(int i = 0; i < N_ITER; i++)
    {
      na.send(7, send_buffer, len);
      r_len = sizeof(receive_buffer);
      na.receive(&src, receive_buffer, &r_len);
    }
    chrono.stop();
    time = chrono.read() - chrono_overhead;

    kprintf("%u\t\t", (unsigned)(time / N_ITER));

    latency = Elapsed_Time(time) / N_ITER / 2;
    kprintf("%u\t\t", (unsigned)(latency * 1E6));

    bandwidth = len / latency;
    kprintf("%u\n", (unsigned)(bandwidth / 1024));
  }

  for(int i = 0; i < sizeof(receive_buffer) / sizeof(int); i++)
    if(receive_buffer[i] != i)
      kprintf("Warning: inconsistent message (offset = %d, data = %d)!\n",
	     i * 4, receive_buffer[i]);

  kprintf("Finish!\n");

  return 0;
}
