#include <system/kprintf.h>
#include <network_adapter.h>
#include <chronometer.h>

#define N_ITER 1000

char buf[8 * 1024 * 1024];

int main()
{
  Elapsed_Time latency;
  double bandwidth;
  Chronometer chrono;
  Network_Adapter_Id src;
  Network_Adapter<> na;
  int r_len;

  kprintf("Myrinet Receive Test\n");

  if(!na.is_valid())
  {
    kprintf("Error: can not access Myrinet!\n");
    return -1;
  }
  
  kprintf("Packet size(b)\tLat(ticks)\tLat(us)\t\tBandwidth(Kbytes/s)\n");
  for(int len = 4; len <= sizeof(buf); len <<= 1)
  {
    kprintf("%d\t\t", len);

    r_len = len;
    na.receive(&src, buf, &r_len);
    if(r_len != len)
      kprintf("Warning: got message of size %d while wainting for %d!\n",
	      r_len, len);
    
    chrono.reset();
    chrono.start();
    for(int i = 0; i < N_ITER; i++)
    {
      r_len = len;
      na.receive(&src, buf, &r_len);
      if(r_len != len)
	kprintf("Warning: got message of size %d while wainting for %d!\n",
		r_len, len);
    }
    chrono.stop();

    kprintf("%u\t\t", (unsigned)(chrono.read() / N_ITER));

    latency = Elapsed_Time(chrono.read()) / N_ITER;
    kprintf("%u\t\t", (unsigned)(latency * 1E6));

    bandwidth = len / latency;
    kprintf("%u\n", (unsigned)(bandwidth / 1024));
  }
  kprintf("Finish!");

  return 0;
}
