#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <network_adapter.h>

extern "C" int get_physical_buffer(int size, int *fd, char **phy_addr);

int buf[64 * 1024 / sizeof(int)];

int main(int argc, char *argv[])
{
  Network_Adapter<> na;
  Network_Adapter_Id src;
  char *phy_addr;
  int fd, r_len;

  printf("Myrinet Pong Test\n");

  if(get_physical_buffer(sizeof(buf), &fd, &phy_addr) < 0)
  {
    fprintf(stderr, "Error: cannot get physical buffer!\n");
    return -1;
  }
  printf("Physical buffer of size %d at %p.\n", 65536, phy_addr);

  if(!na.is_valid())
  {
    fprintf(stderr, "Error: cannot access Myrinet!\n");
    return -1;
  }
  
  while(1)
  {
    r_len = sizeof(buf);
    na.receive(&src, phy_addr, &r_len);
    na.send(src, phy_addr, r_len);
  };
  
  printf("Finish!\n");

  return 0;
}
