#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <network_adapter.h>
#include <chronometer.h>

extern "C" int get_physical_buffer(int size, int *fd, char **phy_addr);

#define N_ITER 1000

int buf[64 * 1024 / sizeof(int)];

int main(int argc, char *argv[])
{
  Elapsed_Time latency;
  double bandwidth;
  Chronometer chrono;
  Network_Adapter<> na;
  Network_Adapter_Id src;
  char *phy_addr;
  int fd, r_len;

  printf("Myrinet Receive Test\n");

  if(argc != 1)
  {
    fprintf(stderr, "Usage: %s\n", argv[0]);
    return -1;
  }

  if(get_physical_buffer(sizeof(buf), &fd, &phy_addr) < 0)
  {
    fprintf(stderr, "Error: cannot get physical buffer!\n");
    return -1;
  }
  printf("Physical buffer of size %d at %p.\n", 65536, phy_addr);

  if(!na.is_valid())
  {
    fprintf(stderr, "Error: cannot access Myrinet!\n");
    return -1;
  }
  
  printf("Packet size(b)\tLat(ticks)\tLat(us)\t\tBandwidth(Kbytes/s)\n");
  for(int len = 4; len <= sizeof(buf); len <<= 1)
  {
    printf("%d\t\t", len);

    r_len = sizeof(buf);
    na.receive(&src, phy_addr, &r_len);
    lseek(fd, 0, SEEK_SET);
    read(fd, buf, len);
    if(r_len != len)
      printf("Warning: got message of size %d while wainting for %d!\n",
	      r_len, len);

    chrono.reset();
    chrono.start();
    for(int i = 0; i < N_ITER; i++)
    {
      r_len = len;
      na.receive(&src, phy_addr, &r_len);
      lseek(fd, 0, SEEK_SET);
      read(fd, buf, len);
      if(r_len != len)
      	printf("Warning: got message of size %d while wainting for %d!\n",
      		r_len, len);
    }
    chrono.stop();

    printf("%Lu\t\t", chrono.read() / N_ITER);

    latency = Elapsed_Time(chrono.read()) / N_ITER;
    printf("%.2f\t\t", latency * 1E6);

    bandwidth = len / latency;
    printf("%.0f\n", bandwidth / 1024);
  }
  
  for(int i = 0; i < sizeof(buf) / sizeof(int); i++)
    if(buf[i] != i)
      printf("Warning: inconsistent message (offset = %d, data = %d)!\n",
	     i * 4, buf[i]);
 
  printf("Finish!\n");

  return 0;
}
