#include <system/abstractions/device/parallel_device/crossoverparalleldevice.h>
#include <system/mediators/parport/ieee1284_parport_pc.h>

__BEGIN_SYS
__BEGIN_IMP


CrossOverParallelDevice::CrossOverParallelDevice()
{
	static IEEE1284_Parport_PC tmp;
    dbtrc << "CrossOverParallelDevice()\n";
//    pp = new IEEE1284_Parport_PC();
    pp = &tmp;
    has_token = false;
}

CrossOverParallelDevice::~CrossOverParallelDevice()
{
    dbtrc << "~CrossOverParallelDevice()\n";
    // delete pp;
}


bool CrossOverParallelDevice::acquire_token() 
{
///   IMPORTANT: this counter should be removed when the clock is used for the wait time!
  unsigned long COUNTER = 0;

  // if it already has the token
  if (has_token)
    return true;

  // if the receiving bit is set to 0 (not receiving)
  if ( !pp->get_pin_10() ) {
    // it sets the sending bit to 1 (sending)
    pp->set_pin_01(true);

/// IMPORTANT: it should replace the counter in the loop for the wait time!
/// time = clock->get_current_time();

    // it waits WAIT_TIME and, if the receiving bit is not set to 1 meanwhile,
    // it gets the token and can start sending any time
    do {
      if ( pp->get_pin_10() )
        return false;

///   IMPORTANT: it should replace the counter in the loop for the wait time!
///   if ((clock.get_current_time() - time) >= WAIT_TIME) {
      if (COUNTER == 1e+5) {
        pp->change_mode(COMPAT);
        has_token = true;
        return true;
      }

///   IMPORTANT: this counter should be removed when the clock is used for the wait time!
      COUNTER++;

    } while (1);
  }

  return false;
}

void CrossOverParallelDevice::release_token() 
{
  // it sets the sending bit to 0 (not sending)
  pp->set_pin_01(false);
  // it looses the token and cannot send anymore
  pp->change_mode(BYTE);
  has_token = false;
}

bool CrossOverParallelDevice::send_byte(Reg8 byte) 
{
  // if it has the token (can send) and
  // the other side has read the last sent byte (the latch is not full)
  if ( has_token && !pp->get_pin_11() ) {
    // it sends the byte
    pp->write(byte);

    // there is a byte to the other side to read
    pp->set_pin_11(true);
    return true;
  }
  return false;
}

bool CrossOverParallelDevice::receive_byte(Reg8 & byte) 
{
  // if it has not the token (can receive) and
  // there is a byte to read (the latch is full)
  if ( !has_token && pp->get_pin_11() ) {
    // it reads the byte
    pp->read(byte);
 
    // it informs the latch is now empty
    pp->set_pin_11(false);
    return true;
  }
  return false;
}


bool CrossOverParallelDevice::send(Reg8 * byte, int size)
{
  int i = 0;
  // if it has the token (can send)
  if (has_token) {
    do {
      if (send_byte(byte[i]))
        i++;
    }
    while (i < size);
    return true;
  }
  return false;
}


bool CrossOverParallelDevice::receive(Reg8 * byte, int & size)
{
  struct ReceiveBuffer {
    Reg8   array[RECEIVE_BUFFER_SIZE];
    int    size;
    struct ReceiveBuffer * next;
  };

  // if it has not the token (can receive)
  if (!has_token) {
    struct ReceiveBuffer * first_buffer = new struct ReceiveBuffer;
    struct ReceiveBuffer * buffer = first_buffer;
    buffer->next = NULL;
    buffer->size = 0;
    Reg8 b;
    int count = 0;

    // while the other side has the token (we are ready to receive)
    while (pp->get_pin_10()) {
      // if there is a latch to read (the latch is full)
      if (this->receive_byte(b))
      {
        if (count == RECEIVE_BUFFER_SIZE)
        {
          buffer->next = new struct ReceiveBuffer;
          buffer = buffer->next;
          buffer->next = NULL;
          buffer->size = 0;
          count++;
        }
        buffer->array[buffer->size++] = b;
      }
    }

    // it creates the output buffer
    size *= count * RECEIVE_BUFFER_SIZE + buffer->size;
    byte = new Reg8[size];
    size = 0;

    buffer = first_buffer;
    while (buffer) {
      for (int i = 0; i < buffer->size; i++)
        byte[size++] = buffer->array[i];
      buffer = buffer->next;
    }
    return true;
  }
  return false;
}


// void CrossOverParallelDevice::method(void)
// {
//     dbtrc << "CrossOverParallelDevice::method()\n";
// }

__END_IMP
__END_SYS


