// #include <device.h>
#include <system/kprintf.h>
#include <sys/io.h>
#include <system/mediators/parport/ieee1284_parport_pc.h>

#define PORT 0x378

using namespace System;

int main()
{
    // iopl(0xFFFF);
    ioperm(0x0000, 0x3ff, 0xFFFFFFFF);

    kprintf("Reseting parallel port registers to zero\n");

    IEEE1284_Parport_PC pp;

    Reg8 data, status, control;

    pp.change_mode(BYTE);

    pp.read(data);
    pp.get_status(status);
    pp.get_control(control);

    kprintf("\tThe data is   : %d\n", data);
    kprintf("\tThe status is : %d\n", status);
    kprintf("\tThe control is: %d\n", control);

    pp.change_mode(COMPAT);

    pp.write(0x00);
    pp.set_status(0x00);
    pp.set_control(0x00);

    pp.change_mode(BYTE);

    pp.read(data);
    pp.get_status(status);
    pp.get_control(control);

    kprintf("\tThe post setting data is   : %d\n", data);
    kprintf("\tThe post setting status is : %d\n", status);
    kprintf("\tThe post setting control is: %d\n", control);

    kprintf("\nReseted!!!!\n");
    return 0;
}
