#include <system/abstractions/envelope/untyped.h>

__BEGIN_SYS
__BEGIN_IMP

Untyped_Envelope::Untyped_Envelope(const Id & r, unsigned int l)
    : Envelope_Common(r, l), _buffer(new char [l]), _ptr(_buffer),
      _max_length(l)
{
    dbtrc(traits::type) << "Untyped_Envelope(r=" << r << ",l=" << l << ")\n";
}

Untyped_Envelope::Untyped_Envelope(const Id & r, unsigned int l, void * b)
    : Envelope_Common(r, l),
      _buffer(reinterpret_cast<char *>(b)), _ptr(0), _max_length(0)
{
    dbtrc(traits::type) << "Untyped_Envelope(r=" << r << ",l=" << l
			<< "b=" << b << ")\n";
}

Untyped_Envelope::~Untyped_Envelope()
{
    dbtrc << "~Untyped_Envelope()\n";
    if(_ptr) delete _buffer;
}

__END_IMP
__END_SYS


