#include <system/abstractions/network/ethernet.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string>
#include <stdio.h>
#include <cpu.h>
#include <traits.h>

__BEGIN_SYS
__BEGIN_IMP

Ethernet::Ethernet()
{
    dbtrc(type) << "Ethernet()\n";

    if((sock = socket(PF_PACKET, SOCK_DGRAM, htons(_protocol))) < 0) {
	perror("Ethernet::Linux::socket");
	exit(-1);
    }

    ifreq ifr;
    strcpy(ifr.ifr_name, CONF_ETHERNET_LINUX_DEV);
    if(ioctl(sock, SIOCGIFINDEX, &ifr) < 0) {
	perror("Ethernet::Linux::ioctl");
	exit(-1);
    }
    dbinf << "Ethernet: using interface " << ifr.ifr_name << "\n";

    memset(&addr, 0, sizeof(sockaddr_ll));
    addr.sll_family = AF_PACKET;
    addr.sll_protocol = htons(_protocol);
//     addr.sll_ifindex = 0;
//     if(bind(sock, (sockaddr *)&addr, sizeof(addr)) < 0) {
// 	perror("");
// 	exit(-1);
//     }
    
    addr.sll_ifindex = ifr.ifr_ifindex;
    addr.sll_hatype = ARPHRD_ETHER;
//     addr.sll_pkttype = 2;
    addr.sll_halen = ETH_HLEN;
//     addr.sll_addr[0] = 0xff;
//     addr.sll_addr[1] = 0xff;
//     addr.sll_addr[2] = 0xff;
//     addr.sll_addr[3] = 0xff;
//     addr.sll_addr[4] = 0xff;
//     addr.sll_addr[5] = 0xff;
//     addr.sll_addr[6] = 0x00;
//     addr.sll_addr[7] = 0x00;
}

Ethernet::~Ethernet()
{
    dbtrc(type) << "~Ethernet()\n";

    close(sock);
}


int Ethernet::send(const Node_Id & r, const void * b, unsigned int l)
{
    dbtrc(type) << "Network::send(" << r << "," << b << "," 
			<< l << ")\n";

    sockaddr_ll to;
    to.sll_family = AF_PACKET;
    to.sll_protocol = htons(_protocol);
    to.sll_ifindex = 1;
    to.sll_hatype = ARPHRD_ETHER;
    to.sll_pkttype = PACKET_HOST;
    to.sll_halen = ETH_HLEN;
    to.sll_addr[0] = arp_table[1][0];
    to.sll_addr[1] = arp_table[1][1];
    to.sll_addr[2] = arp_table[1][2];
    to.sll_addr[3] = arp_table[1][3];
    to.sll_addr[4] = arp_table[1][4];
    to.sll_addr[5] = arp_table[1][5];
//     to.sll_addr[0] = 0x00;
//     to.sll_addr[1] = 0x00;
//     to.sll_addr[2] = 0x00;
//     to.sll_addr[3] = 0x00;
//     to.sll_addr[4] = 0x00;
//     to.sll_addr[5] = 0x00;

    Frame frame;
//     frame.header.to = arp_table[r];
//     frame.header.from = arp_table[Node::id()];
//     frame.header.protocol = htons(_protocol);
    memcpy(frame.payload, b, l);

    if(sendto(sock, &frame.payload, l, 0,
	      (sockaddr *)&to, sizeof(sockaddr_ll)) < 0) {
	perror("Linux");
	return -1;
    }

    dbinf(type) << "Network::send => header = [t=";
    //   for(unsigned int i = 0; i < alen; i++)
	dbinf << (void *)frame.header.to[5];
    dbinf << ",f=";
    //   for(unsigned int i = 0; i < alen; i++)
	dbinf << (void *)frame.header.from[5];
    dbinf << ",t=" << ntohs(frame.header.protocol) << "]\n";
 
    return 0;
}
 
int Ethernet::receive(Node_Id * s, void * b, unsigned int * l)
{
    socklen_t addrlen;
    sockaddr_ll from;

    Frame frame;
    addrlen = sizeof(sockaddr_ll);
    if((*l = recvfrom(sock, &frame.payload, sizeof(Frame), 0,
		      (sockaddr *)&from, &addrlen)) < 0) {
	perror("Linux");
	return -1;
    }

    memcpy(&frame.header.from, from.sll_addr, _alen);
    frame.header.to = arp_table[Node::id()];

    unsigned int i;
    for(i = 0; i < _nodes; i++)
	if(arp_table[i] = frame.header.from)
	    break;
    if(i == _nodes)
	*s = ANY_NODE;
    else 
	*s = i;

    memcpy(b, frame.payload, *l);

    dbinf(type) << "Network::receive => header = [t=";
    for(unsigned int i = 0; i < _alen; i++)
	dbinf << (void *)frame.header.from[i];
    dbinf << ",f=";
    for(unsigned int i = 0; i < _alen; i++)
	dbinf << (void *)frame.header.from[i];
    dbinf << ",t=" << ntohs(frame.header.protocol) << "]\n";

    dbtrc(type) << "Network::receive(" << *s << "," << b << "," 
			<< *l << ")\n";

    return 0;
}

// int Ethernet::receive(Node_Id * s, void * b, unsigned int * l)
// {
//     socklen_t addrlen;
//     sockaddr_ll tmp;

//     Frame frame;
//     addrlen = sizeof(sockaddr_ll);
// //    do {
// 	if((*l = recvfrom(sock, &frame, sizeof(Frame), 0,
// 			  (sockaddr *)&tmp, &addrlen)) < 0) {
// 	    perror("Linux");
// 	    return -1;
// 	}
// //    } while (frame.header.protocol != htons(_protocol));

//     unsigned int i;
//     for(i = 0; i < _nodes; i++)
// 	if(arp_table[i] = frame.header.from)
// 	    break;
//     if(i == _nodes)
// 	*s = ANY_NODE;
//     else 
// 	*s = i;

//     *l -= sizeof(Header);
//     memcpy(b, frame.payload, *l);

//     dbinf(type) << "Network::receive => header = [t=";
//     //   for(unsigned int i = 0; i < alen; i++)
// 	dbinf << (void *)frame.header.to[5];
//     dbinf << ",f=";
//     //   for(unsigned int i = 0; i < alen; i++)
// 	dbinf << (void *)frame.header.from[5];
//     dbinf << ",t=" << ntohs(frame.header.protocol) << "]\n";

//     dbtrc(type) << "Network::receive(" << *s << "," << b << "," 
// 			<< *l << ")\n";

//     return 0;
// }

__END_IMP
__END_SYS


