#include <system/abstractions/network/loop.h>
#include <string>

__BEGIN_SYS
__BEGIN_IMP

Loop::Loop()
{
    dbtrc(type) << "Loop()\n";
}

Loop::~Loop()
{
    dbtrc(type) << "~Loop()\n";
}

int Loop::send(const Node_Id & r, const void * b, unsigned int l)
{
    dbtrc(type) << "Loop::send(" << r << "," << b << "," << l << ")\n";

    if(l > _mtu)
	return 1;

    while(full);

    id = r;
    length = l;
    memcpy(buffer, b, length);
    full = true;

    return 0;
}
 
int Loop::receive(Node_Id * s, void * b, unsigned int * l)
{

    while(!full);
    
    if(length > *l)
	return 1;

    *s = id;
    *l = length;
    memcpy(b, buffer, length);
    full = false;

    dbtrc(type) << "Loop::receive(" << *s << "," << b << "," << *l << ")\n";

    return 0;
}

__END_IMP
__END_SYS


