#include <system/abstractions/thread/exclusive.h>
#include <signal.h>

__BEGIN_SYS
__BEGIN_IMP

Exclusive_Thread::Exclusive_Thread(const Thread_Self &)
{
    dbtrc(traits::type) << "Thread(SELF)\n";
    thread = pthread_self(); 
}

Exclusive_Thread::~Exclusive_Thread()
{
    dbtrc << "~Thread()\n";
    pthread_kill(thread, SIGKILL); 
}

void Exclusive_Thread::stat(Thread_Status *)
{
    dbtrc << "Thread:stat()\n";
}

void Exclusive_Thread::exit(int ret)
{
    dbtrc << "Thread:exit(" << ret << ")\n";
    pthread_exit((void *) ret); 
}

__END_IMP
__END_SYS


