#include <config.h>
#include <system/mediators/node/sp_pc.h>
#include <system/abstractions/network/ethernet.h>
#include <system/info.h>
#include <system/memory_map.h>
#include <system/kprintf.h>

#include <system/initializer.h>

__BEGIN_SYS

extern System_Info * system_info;

typedef int (Init_Dispatcher) (System_Info * info);

static Init_Dispatcher * init_table[LAST_TYPE + 1] = {
    &SP_PC::init,
    &__IMP(Ethernet)::init,
};

Initializer::Initializer(System_Info *si)
{
    kprintf("Initializing EPOS abstractions:\n");

    for(int i = 0; i <= LAST_TYPE; i++) {
	if(init_table[i]) {
	    volatile int err = init_table[i](si);
	    if(err)
		kprintf("Initializtion of abstraction %d failed!\n", i);
	}
    }

//   Basic_CPU_Imp::init(si);
//   Basic_Node_Imp::init(si);

//   running_thread = (System::Thread_Imp *)si->log_mem_map.thread_tab;
//   System::Thread_Imp::init(running_thread);

//   thread_scheduler = new System::Thread_Scheduler;
}

__END_SYS

