#include <system/mediators/parport/ieee1284_parport_pc.h>
#include <pc/ix86.h>

__BEGIN_SYS

IEEE1284_Parport_PC::IEEE1284_Parport_PC()
{
    dbtrc << "IEEE1284_Parport_PC()\n";
    this->port = 0x378;
    this->mode = COMPAT;
}

IEEE1284_Parport_PC::IEEE1284_Parport_PC(Ix86_Reg16 port)
{
    dbtrc << "IEEE1284_Parport_PC(Ix86_Reg16 port)\n";
    this->port = port;
    this->mode = COMPAT;
}

IEEE1284_Parport_PC::~IEEE1284_Parport_PC()
{
    dbtrc << "~IEEE1284_Parport_PC()\n";
}

// --------------------------------------------------------------
// Get/Set pins [in modern hardware we can do this with all pins] 
bool IEEE1284_Parport_PC::get_pin_10()
{
    Reg8 status;
    get_status(status);

    return (0x01 & status) != 0;
}

void IEEE1284_Parport_PC::set_pin_01(bool value)
{
    Reg8 control;

    get_control(control);
    control = (control & 0xFE) | value;
    set_control(control);
}

void IEEE1284_Parport_PC::set_pin_11(bool value)
{
    Reg8 status;
 
    get_status(status);
    status = (status & 0xFD) | (value << 1);
    set_status(status);
}

bool IEEE1284_Parport_PC::get_pin_11()
{
    Reg8 status;
    get_status(status);

    return (0x02 & status) != 0;
}
// -----------------------------------------------------

void IEEE1284_Parport_PC::get_status(Reg8 & byte)
{
    /*
 	Bit order: ## ## ## 15 13 12 11 10
    */
    Reg8 status = ix86_inb(port+1);

    byte  = (0x40 & status) >> 6;  // mask: 0100 0000
    byte |= (0x80 & status) >> 6;  // mask: 1000 0000
    byte |= (0x20 & status) >> 3;  // mask: 0010 0000
    byte |= (0x10 & status) >> 1;  // mask: 0001 0000
    byte |= (0x08 & status) << 1;  // mask: 0000 1000 
}

void IEEE1284_Parport_PC::set_status(Reg8 byte)
{
    /*
 	Bit order: ## ## ## 15 13 12 11 10
    */
    Reg8 status;

    status  = (0x01 & byte) << 6; // mask: 0000 0001
    status |= (0x02 & byte) << 6; // mask: 0000 0010
    status |= (0x04 & byte) << 3; // mask: 0000 0100
    status |= (0x08 & byte) << 1; // mask: 0000 1000
    status |= (0x10 & byte) >> 1; // mask: 0001 0000    

    ix86_outb(port+1, status);
}

void IEEE1284_Parport_PC::get_control(Reg8 & byte)
{
    /*
 	Bit order: ## ## ## ## 17 16 14 01 
    */
    
    byte = 0x0F & ix86_inb(port+2);
}

void IEEE1284_Parport_PC::set_control(Reg8 byte)
{
    /*
 	Bit order: ## ## ## ## 17 16 14 01 
    */

    ix86_outb(port+2, 0x0F & byte);
}

bool IEEE1284_Parport_PC::read(Reg8 & byte)
{
    dbtrc << "IEEE1284_Parport_PC::read()\n";
    if ( mode != COMPAT ){
      byte = ix86_inb(port);
      return true;
    }

    return false;
}

bool IEEE1284_Parport_PC::write(Reg8 byte)
{
    dbtrc << "IEEE1284_Parport_PC::write()\n";
    if ( mode == COMPAT ){
      ix86_outb(port, byte);
      return true;
    }

    return false;
}

Mode IEEE1284_Parport_PC::change_mode(Mode mode)
{
    dbtrc << "IEEE1284_Parport_PC::change_mode()\n";
    if ( mode == EPP || mode == ECP ) {
	dbtrc << "EPP/ECP not supported yet! \n";
    }else{
    	this->mode = mode;
    }
    return this->mode;
}

Mode IEEE1284_Parport_PC::get_mode()
{
    dbtrc << "IEEE1284_Parport_PC::get_mode()\n";
    return this->mode;
}

bool IEEE1284_Parport_PC::read_burst(int init_pointer, int size)
{
    dbtrc << "IEEE1284_Parport_PC::read_burst(int init_pointer, int size)\n";
    dbtrc << "Not supported yet! \n";
    return false;
}

bool IEEE1284_Parport_PC::write_burst(int init_pointer, int size)
{
    dbtrc << "IEEE1284_Parport_PC::write_burst(int init_pointer, int size)\n";
    dbtrc << "Not supported yet! \n";
    return false;
}

// void IEEE1284_Parport_PC::method(void)
// {
//     dbtrc << "IEEE1284_Parport_PC::method()\n";
// }

__END_SYS


