#include <system/kprintf.h>
#include <cpu_timer.h>

#define ITERACTIONS 10

USING_SYSTEM_NAMESPACE

int main()
{
  CPU_Timer timer;

  kprintf("CPU Timer Test\n");

  kprintf("  Timer Resolution: %u ns\n",
	  (unsigned)(timer.get_resolution()*1E9));

  long long int lap, min = 10000, max = 0, avg = 0;
  volatile Timer_Tick t0, t1;
  for(int i = 0; i < ITERACTIONS; i++) {
    t0 = timer.get_tick();
    t1 = timer.get_tick();

    lap = t1 - t0;
    if(lap < min)
      min = lap;
    if(lap > max)
      max = lap;
    avg += lap;

    kprintf("  Timer overhead: %u ticks (%u ns)\n",
	    (unsigned)lap, (unsigned)(lap * timer.get_resolution() * 1E9));
  }
  avg/= ITERACTIONS;

  kprintf("  Minimun timer overhead: %u ticks (%u ns)\n",
	    (unsigned)min, (unsigned)(min * 1E9 * timer.get_resolution()));
  kprintf("  Average timer overhead: %u ticks (%u ns)\n",
	    (unsigned)avg, (unsigned)(avg * 1E9 * timer.get_resolution()));
  kprintf("  Maximun timer overhead: %u ticks (%u ns)\n",
	    (unsigned)max, (unsigned)(max * 1E9 * timer.get_resolution()));
  
  kprintf("  Delaying for 1E10 timer ticks: ");
  timer.delay(1000000000);
  kprintf("done!\n");

  return 0;
}
