/*
Implementa um parser para o cabecalho IP;
Os buffers devem ser gerenciados pelo usuario;
Ha 2 estruturas de cabecalho: uma que contem as informacoes
"locais" (src_ip_header) e outra que contem as informacoes
extraidas do pacote recebido (dst_ip_header);
src_ip_header deve ser inicialmente configurado ao construir o objeto,
posteriormente eh necessario somente configurar o endereco ip destino
na estrutura src_ip_header;
*/

/*
TODO:
- o que colocar/conferir em alguns campos como tos, cksum, fragoff, id?
*/

/*#include <system/abstractions/envelope/ip.h>*/
#include <string.h>
#include <stdlib.h>
#include "ip.h"

/*
__BEGIN_SYS
__BEGIN_IMP
*/

IP::IP(ip_struct *src) {
        memcpy(&this->src_ip_header,src,sizeof(ip_struct));
}

IP::~IP(void) {
}

void IP::make_packet(unsigned char *buffer_dst,unsigned char *buffer_src, int len_src) {
	unsigned char *p;

	p = buffer_dst;
	*p++ = this->src_ip_header.ip_verlen;
	*p++ = this->src_ip_header.ip_tos;
	this->src_ip_header.ip_len = ((short)len_src)+20;
	memcpy(p,&this->src_ip_header.ip_len, 2);
	p += 2;
	memcpy(p,&this->src_ip_header.ip_id, 2);
	p += 2;
	memcpy(p,&this->src_ip_header.ip_fragoff, 2);
	p += 2;
	*p++ = this->src_ip_header.ip_ttl;
	*p++ = this->src_ip_header.ip_proto;
	memcpy(p,&this->src_ip_header.ip_cksum, 2);
	p += 2;
	memcpy(p,&this->src_ip_header.ip_src, 4);
	p += 4;
	memcpy(p,&this->src_ip_header.ip_dst, 4);
	p += 4;
	memcpy(p, buffer_src, len_src);
}

int IP::parse_packet(unsigned char *buffer_dst,unsigned char *buffer_src){
        unsigned char *p;

        p = buffer_src;
        if((this->dst_ip_header.ip_verlen = *p++) != 0x45)
		return -1;
        this->dst_ip_header.ip_tos = *p++;
        memcpy(&this->dst_ip_header.ip_len, p, 2);
        p += 2;
        memcpy(&this->dst_ip_header.ip_id, p, 2);
        p += 2;
        memcpy(&this->dst_ip_header.ip_fragoff, p, 2);
        p += 2;
	/* como nao passa por roteador, ttl deve ser o inicial: 0xff */
        if((this->dst_ip_header.ip_ttl = *p++) != 0xFF)
		return -2;
        *p++ = this->dst_ip_header.ip_proto;
        memcpy(&this->dst_ip_header.ip_cksum, p, 2);
        p += 2;
        memcpy(&this->dst_ip_header.ip_src, p, 4);
        p += 4;
        memcpy(&this->dst_ip_header.ip_dst, p, 4);
        p += 4;
	/* se o destino do pacote que chegou nao for o ip local, erro */
	if(!memcmp(this->dst_ip_header.ip_dst,this->src_ip_header.ip_src,4))
		return -3;

	memcpy(buffer_dst, p, this->dst_ip_header.ip_len-20);

	return this->dst_ip_header.ip_len-20;
}

ip_struct *IP::get_dst_ip_struct(void){
	return &dst_ip_header;
}

void IP::set_src_ip_struct(IPaddr *dst, unsigned char proto){
	memcpy(&src_ip_header.ip_dst, dst,4);
	src_ip_header.ip_proto = proto;
}

/*
__END_IMP
__END_SYS
*/
