#ifndef __ip_envelope_h
#define __ip_envelope_h

/*
__BEGIN_SYS
__BEGIN_IMP
*/

#define IP_ALEN 4
typedef char IPaddr[IP_ALEN];

struct ip_struct {
	unsigned char	ip_verlen;
	unsigned char	ip_tos;
	short		ip_len;
	short		ip_id;
	short		ip_fragoff;
	unsigned char	ip_ttl;
	unsigned char	ip_proto;
	short		ip_cksum;
	IPaddr		ip_src;
	IPaddr		ip_dst;
	unsigned char	ip_data[];
};

class IP {
	protected:
		ip_struct src_ip_header,dst_ip_header;
	public:
		IP(ip_struct *src);
		~IP(void);
                void make_packet (unsigned char *buffer_dst,unsigned char *buffer_src, int len_src);
		int parse_packet (unsigned char *buffer_dst,unsigned char *buffer_src);
		ip_struct *get_dst_ip_struct(void);
		void set_src_ip_struct(IPaddr *dst, unsigned char proto);
};

/*
__END_IMP
__END_SYS
*/

#endif
