#include <iostream>
#include <stdio.h>
#include "ip.h"

/*
using namespace System;
*/

int main(void){
	unsigned char buf_rec[128], buf_send[128], buf_ip[148];
	int len;
	IP *ip;
	IPaddr dst_ip = {0xC0, 0xA8, 0x00, 0x02};
	ip_struct s_h = {0x45, 0, 0, 0, 0, 0xFF, 8, 0, 
			{0xC0, 0xA8, 0x00, 0x01}, {0,0,0,0}};

	cout << "IP test\n";

	for(int k = 0; k < 128; k++)
		buf_rec[k] = 0;

	for(int k=0, c='a'; c<='z'; c++, k++)
		buf_send[k] = c;

	ip = new IP(&s_h);

	len = ((int)'z') - ((int)'a')+1;
	ip->set_src_ip_struct(&dst_ip, 8);
	ip->make_packet(buf_ip, buf_send, len);
	printf("Sent:\nlen = %d\n", len+20);
	for(int k = 0; k<len+20; k++){
		if(k<20)
			printf("%x ", buf_ip[k]);
		else if(k==20)
			printf("\n%c ", buf_ip[k]);
		else
			printf("%c ", buf_ip[k]);
	}

	if((len = ip->parse_packet(buf_rec, buf_ip))<0){
		printf("Error!");
		return 1;
	}

	printf("\nReceived:\nlen = %d\n", len);
	for(int k=0; k<len; k++)
		printf("%c ", buf_rec[k]);

	delete ip;

	cout << "\nEnd IP test\n";

	return 0;
}
